/* Wiktor Zychla, 2003 */
using System;
using System.Diagnostics;
using System.IO;
using System.CodeDom;
using System.CodeDom.Compiler;
using System.Reflection;

using Microsoft.CSharp;

namespace Example
{
  public class CExample 
  {
    public delegate int DF( int n );
    public static DF DummyDF = new DF( FDummy );
    public static int FDummy( int n )
    {
      return 0;
    }

    public static void Main(string[] args)
    {
      string sFileName;
      string sOutFileName;

      Console.Write( "Podaj nazwe pliku do skompilowania: " );
      sFileName    = Console.ReadLine();
      sOutFileName = 
        Path.GetFileNameWithoutExtension( sFileName ) + ".exe";

      if ( File.Exists( sFileName ) )
      {
        CSharpCodeProvider codeProvider = new CSharpCodeProvider();
        ICodeCompiler icc = codeProvider.CreateCompiler();

        CompilerParameters parameters = new CompilerParameters();
        parameters.GenerateExecutable = false;
        parameters.OutputAssembly     = sOutFileName;
     
        CompilerResults results = 
          icc.CompileAssemblyFromFile( parameters, sFileName );
      
        if (results.Errors.Count > 0)
        {
          foreach(CompilerError CompErr in results.Errors)
          {
            Console.WriteLine( "Linia: " + CompErr.Line + 
                               ", Numer: " + CompErr.ErrorNumber );
            Console.WriteLine( CompErr.ErrorText );
          }
        }
        else
        {
          try
          {
            Assembly  assembly = results.CompiledAssembly;

            Console.Write( "Podaj nazw typu: " );
            Type t = assembly.GetType( Console.ReadLine() );
          
            Console.Write( "Podaj nazw funkcji o prototypie int F(int): " );
            MethodInfo me = t.GetMethod( Console.ReadLine() );

            DF df = (DF)DF.CreateDelegate( DummyDF.GetType(), me  );
            Console.Write( "Podaj warto parametru (int): " );

            int result = df( int.Parse( Console.ReadLine() ) ); 
            Console.WriteLine( result ); 
           }
           catch ( Exception ex )
           {
             Console.WriteLine( ex.Message );
           } 
        }
      }
    }
  }
}
